local pn=...;
local t=Def.ActorFrame{};

local RadarPrm={"Stream","Chaos","Freeze","Air","Voltage"};
local keymode=false;

if not GAMESTATE:IsPlayerEnabled(pn) then
	return t;
end;

t[#t+1]=Def.ActorFrame{
	PlayerJoinedMessageCommand=cmd(playcommand,"Joined");
	OnCommand=cmd(playcommand,"Joined");
	LoadActor("_GrooveRadar base")..{
		InitCommand=function(self)
			self:diffuse(PlayerColor(pn));
			self:diffusealpha(1.0);
		end;
		JoinedCommand=function(self)
			self:player(pn);
		end;
	};
	LoadActor(THEME:GetPathG("_SelectMusic/white","difficulty (doubleres)"))..{
		InitCommand=function(self)
			self:zoom(1.1);
			self:diffusealpha(0.5);
			self:blend('BlendMode_Add');
		end;
		JoinedCommand=function(self)
			self:player(pn);
		end;
	};
	--[[
	LoadActor("_GrooveRadar over")..{
		InitCommand=function(self)
			self:diffuse(Color("White"));
			self:diffusealpha(1.0);
			self:blend('BlendMode_Add');
		end;
		JoinedCommand=function(self)
			self:player(pn);
		end;
	};
	--]]

};
t[#t+1]=Def.ActorFrame{
	InitCommand=cmd(playcommand,"Joined");
	OnCommand=cmd(playcommand,"Joined");
	LoadActor("_GrooveRadar autogen")..{
		JoinedCommand=function(self)
			self:player(pn);
			self:diffuse(PlayerColor(pn));
			self:playcommand("Changed");
		end;
		ChangedCommand=function(self)
			local step=GAMESTATE:GetCurrentSteps(pn);
			if _SONG() then
				if step and step:IsAutogen() then
					self:stoptweening();
					--[[
						self:x((pn==PLAYER_1) and -42 or 42);
						self:y(-55);
					--]]
					self:rotationz(-35);
					self:zoom(4);
					self:diffusealpha(0);
					self:linear(0.1);
					self:diffusealpha(1);
					self:zoom(2);
					--self:blend("BlendMode_Add")
					self:visible(1);
				else
					self:visible(0);
				end;
			else
				self:visible(0);
			end;
		end;
	};
	Def.GrooveRadar {
		InitCommand=cmd(diffuse,BoostColor(PlayerColor(pn),1.0);zoom,1.3);
		ChangedCommand=function(self)
			local rv=GAMESTATE:GetCurrentSteps(pn):GetRadarValues(pn);
			local v={};
			local song=_SONG();
			if not song then
				self:SetEmpty(pn);
			else
				v[#v+1]=yaGetRadarVal(song,pn,'Stream',false)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Voltage',false)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Air',false)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Freeze',false)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Chaos',false)*0.01;
				self:SetFromValues(pn,v);
			end;
		end;
	};
	--[[
	Def.GrooveRadar {
		InitCommand=cmd(diffuse,1.0,1.0,1.0,0.5;zoom,1.3);
		ChangedCommand=function(self)
			local rv=GAMESTATE:GetCurrentSteps(pn):GetRadarValues(pn);
			local v={};
			local song=_SONG();
			if not song then
				self:SetEmpty(pn);
			else
				v[#v+1]=yaGetRadarVal(song,pn,'Stream',true)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Voltage',true)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Air',true)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Freeze',true)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Chaos',true)*0.01;
				self:SetFromValues(pn,v);
			end;
		end;
	};
	--]]
};

local radar_name={"STR","CHA","FRZ","AIR","VOL"};
for i=1,5 do
t[#t+1]=Def.ActorFrame{
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:player(pn);
			self:x(55.0*math.sin(2*math.pi*(i-1)/5));
			self:y(55.0*math.cos(2*math.pi*(i-1)/5)*(-1));
			self:rotationz(360*(i-1)/5);
			self:diffuse(Color("Black"));
			self:strokecolor(Color("White"));
			self:settextf("%s",radar_name[i]);
			self:diffusealpha(0);
			self:zoom(0);
			self:sleep(_TT.S_IN);
		end;
		JoinedCommand=function(self)
			self:decelerate(0.2);
			self:diffusealpha(0.5);
			self:zoom(0.5);
		end;
		OnCommand=cmd(playcommand,"Joined");
		PlayerJoinedMessageCommand=cmd(queuecommand,"Init";queuecommand,"Joined");
	};
};
end;

local old_step=nil;
local function update(self)
	if _SONG() then
		local st=_STEPS2(pn);
		if old_step~=st then
			old_step=st;
			self:playcommand("Changed");
		end;
	else
		if old_step~=nil then
			old_step=nil;
			self:playcommand("Changed");
		end;
	end;
end;

t.InitCommand=cmd(SetUpdateFunction,update);

return t;